/*******************************************************
Filename		:  org_tables.sql
Release 		:  c2.0
SIR			:  1367, 1480
Description		:  Creates Org dimension table and related constraints and populates data.
Author			:  Ganesh Thadkamalla
Date			:  10/01/2002.
Comments		:  11/26/2002 - Droped lu_geo_country table and its associations. G.Thadkamalla.
**********************************************************/
connect storetw/storetw@storet.sdc

spool org_tables.log
set echo on
drop sequence seq_org;
-- currently this sequence is not being used in the script.
create sequence seq_org
start with 1 increment by 1 nomaxvalue nocycle cache 10;

drop table di_org;

create table di_org
(pk_isn number(12,0),
 ORGanization_ID  CHAR(8) not null,
 organization_NAME   VARCHAR2(60) not null,
 organization_is_number number(8)
);

alter table di_org
add constraint pk_org primary key (pk_isn)
using index
tablespace STORETINDX
storage (initial 300k next 300k)
nologging;

set serveroutput on
declare 
cursor c_org is 
select ORG_ID,name,TSMORGAN_IS_NUMBER 
from storet1.tsmorgan o
where exists (select 'x' from fa_station f
             where f.ORGANIZATION_IS_NUMBER=o.tsmorgan_is_number);

begin
 for c_var in c_org loop
  insert into di_org
    (pk_isn,organization_id,organization_name,organization_is_number)
  values
    (seq_org.nextval, c_var.org_id,c_var.name,c_var.tsmorgan_is_number);
 end loop;
end;
/


alter table fa_station
add( fk_org number(12,0));

update fa_station f
set fk_org = (select pk_isn from di_org o
              where o.organization_is_number=f.organization_is_number)
where f.organization_is_number is not null;
commit;

create index isd_org1 on fa_station(fk_org)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

create index iorgtemp1 on di_org(organization_id)
tablespace STORETINDX
storage (initial 512k next 512k)
nologging;

commit;

alter table fa_station
add constraint fk_sd_org foreign key (fk_org) references di_org(pk_isn);


spool off;